/*
 * Decompiled with CFR 0.152.
 */
package com.articles.service;

import com.articles.repo.ArticleRepo;
import com.articles.repo.domain.Article;
import com.articles.repo.domain.Chapter;
import com.articles.repo.domain.Tag;
import com.articles.service.ArticleService;
import com.articles.service.TagService;
import com.articles.web.dto.ChapterDTO;
import jakarta.transaction.Transactional;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class TransactionalArticleService
implements ArticleService {
    private final TagService tagService;
    private final ArticleRepo articleRepo;

    public Article save(Article article) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (article.getTags().size() > 0) {
            for (Tag tag : article.getTags()) {
                tags.add(this.tagService.findByTitle(tag.getTitle()).orElseGet(() -> this.tagService.save(new Tag(tag.getTitle()))));
            }
        }
        article.setTags(tags);
        if (article.getLastModified() == null) {
            article.setLastModified(Instant.now());
        }
        return (Article)this.articleRepo.save((Object)article);
    }

    public Article getById(String id) {
        Article article = (Article)this.articleRepo.findById((Object)id).orElseThrow(RuntimeException::new);
        article.setViews(article.getViews() + 1L);
        article.setKeywords(this.extractKeywords(article.getText()));
        return this.save(article);
    }

    public List<ChapterDTO> findAllUniqueChapters() {
        Set uniqueChapters = this.articleRepo.findAll().stream().map(a -> a.getChapter().name()).collect(Collectors.toSet());
        ArrayList<ChapterDTO> enhancedChapters = new ArrayList<ChapterDTO>();
        for (String ch : uniqueChapters) {
            Long count = this.articleRepo.countByChapter(Chapter.valueOf((String)ch));
            enhancedChapters.add(new ChapterDTO(Chapter.valueOf((String)ch), ch + " (" + count + ") "));
        }
        return enhancedChapters;
    }

    public List<Article> getMostPopularArticles() {
        return this.articleRepo.findAll().stream().sorted(Comparator.comparing(Article::getViews).reversed()).limit(10L).collect(Collectors.toList());
    }

    public List<Article> getAll() {
        List all = this.articleRepo.findAll();
        for (Article article : all) {
            article.setTitle(article.getTitle().replace("<h2>", "").replace("</h2>", ""));
        }
        return all;
    }

    public List<Article> findNextRandomArticles(Article currentArticle) {
        List articlesByChapter = this.articleRepo.findAllByChapter(currentArticle.getChapter());
        if (articlesByChapter.size() < 4) {
            return articlesByChapter;
        }
        articlesByChapter.remove(currentArticle);
        ArrayList<Article> randomArticles = new ArrayList<Article>();
        Article article1 = (Article)articlesByChapter.get(new Random().nextInt(articlesByChapter.size()));
        article1.setTitle(article1.getTitle().replace("<h2>", "").replace("</h2>", ""));
        randomArticles.add(article1);
        Article article2 = (Article)articlesByChapter.get(new Random().nextInt(articlesByChapter.size()));
        article2.setTitle(article2.getTitle().replace("<h2>", "").replace("</h2>", ""));
        randomArticles.add(article2);
        Article article3 = (Article)articlesByChapter.get(new Random().nextInt(articlesByChapter.size()));
        article3.setTitle(article3.getTitle().replace("<h2>", "").replace("</h2>", ""));
        randomArticles.add(article3);
        if (articlesByChapter.size() > 20) {
            Article article4 = (Article)articlesByChapter.get(new Random().nextInt(articlesByChapter.size()));
            article4.setTitle(article4.getTitle().replace("<h2>", "").replace("</h2>", ""));
            randomArticles.add(article4);
            Article article5 = (Article)articlesByChapter.get(new Random().nextInt(articlesByChapter.size()));
            article5.setTitle(article5.getTitle().replace("<h2>", "").replace("</h2>", ""));
            randomArticles.add(article5);
        }
        return randomArticles;
    }

    public List<Article> getRandomArticlesByChapters() {
        ArrayList<Article> randomArticles = new ArrayList<Article>();
        for (ChapterDTO chapter : this.findAllUniqueChapters()) {
            List allByChapterName = this.findAllByChapterName(chapter.getChapter().name());
            int random = new Random().nextInt(allByChapterName.size());
            randomArticles.add((Article)allByChapterName.get(random));
        }
        return randomArticles;
    }

    public List<Article> findAllByChapterName(String chapterName) {
        return this.articleRepo.findAllByChapter(Chapter.valueOf((String)chapterName));
    }

    private String extractKeywords(String text) {
        HashMap<String, Integer> wordFrequency = new HashMap<String, Integer>();
        for (String word : text.toLowerCase().split("\\W+")) {
            if (word.length() <= 3) continue;
            wordFrequency.merge(word, 1, Integer::sum);
        }
        List keywordsAsList = wordFrequency.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).map(Map.Entry::getKey).collect(Collectors.toList());
        StringBuilder keywords = new StringBuilder();
        if (keywordsAsList.size() > 0) {
            keywords.append((String)keywordsAsList.get(0));
            for (int i = 1; i < keywordsAsList.size(); ++i) {
                keywords.append(", ").append((String)keywordsAsList.get(i));
            }
        }
        return keywords.toString();
    }

    public TransactionalArticleService(TagService tagService, ArticleRepo articleRepo) {
        this.tagService = tagService;
        this.articleRepo = articleRepo;
    }
}

